#include<cstdio>
#include<cstring>
#include<algorithm>
#include<iostream>
#include<cmath>
#include<set>
#include<vector>
#include<ctime>
#include<random>
using namespace std;
const int N = 4941; // number of demands
const double facility_cost = 20;
const double eps = 1e-7;
const int dim = 3; //dimension 
double cost = 0; // total cost 
double follow_cost = 0;
struct demand {
	int t;
	double x[dim + 1];
	double r;
}D[N + 1], P[N + 1];
vector<int> Fset; // the set of open facility in our algorithm
vector<int> follow; // the set of open facility in follow prediction
default_random_engine e;
uniform_real_distribution<double> u(0,1); 
double g[N + 1][N + 1]; // g[i][j] represents the distance between i-th point and j-th point

inline double dist(demand &d1, demand &d2) {
	double ret = 0;
	for (int i = 1; i <= dim; i++)
		ret += (d1.x[i] - d2.x[i]) * (d1.x[i] - d2.x[i]);
	return sqrt(ret);
}

double getcost(int x) {
	double connect_cost = 1e9;
	int siz = Fset.size();
	for (int j = 0; j < siz; j++) {
		int pos = Fset[j];
		connect_cost = min(connect_cost, g[x][pos]);
	}
	return connect_cost;
}

bool open(int d, vector<int> &S) { // check whether facility d in set S
	int siz = S.size();
	for (int i = 0; i < siz; i++) {
		if (S[i] == d)
			return 1;
	}
	return 0;
}


int main() {
	//freopen("timestamped_gps_coordinate.txt", "r", stdin);
	//freopen("lb.txt", "r", stdin);
	//freopen("Census.txt", "r", stdin);
	freopen("USpowerGrid.txt", "r", stdin);
	for (int i = 1; i <= N; i++) 
		for (int j = i + 1; j <= N; j++) {
			int a, b, c;
			scanf("%d %d %d", &a, &b, &c);
			g[a][b] = g[b][a] = c;
		}
	freopen("USpowerGrid15_order.txt", "r", stdin);
	//freopen("open_facility_adult100.txt", "r", stdin);
	for (int i = 1; i <= N; i++) 
		scanf("%d", &D[i].t);
	freopen("USpowerGrid15_order_predict.txt", "r", stdin);
	for (int i = 1; i <= N; i++) {
		scanf("%d", &P[i].t);
		follow_cost += g[D[i].t][P[i].t];
		if (!open(P[i].t, follow))
			follow.push_back(P[i].t);
	}
		
	for (int cnt = 1; cnt <= 10; cnt++) {
		e.seed(time(0));
		Fset.clear();
		for (int i = 1; i <= N; i++) {
			double connect_cost = getcost(D[i].t);
			if (connect_cost  >  facility_cost) {
				if (!open(P[i].t, Fset))
					Fset.push_back(P[i].t);
			}
			else {
				double r = u(e);
				if (facility_cost * r  <= connect_cost) 
					if (!open(P[i].t, Fset))
						Fset.push_back(P[i].t);
			}
			connect_cost = getcost(D[i].t);
			if (connect_cost  >  facility_cost) 
					Fset.push_back(D[i].t);
			else {
				double r = u(e);
				if (facility_cost * r  <= connect_cost) 
					Fset.push_back(D[i].t);
				else 
					cost += connect_cost;
			}
			
		}
		cost += (Fset.size() * facility_cost);
	}
	follow_cost += (follow.size() * facility_cost); 
	printf("%lf\n", cost / 10);
	printf("%lf\n", follow_cost);
	printf("%lu\n", Fset.size());
}